<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

use Erlage\Photogram\Data\Query;
use Erlage\Photogram\Data\Common\CommonQueries;
use Erlage\Photogram\Data\Tables\Post\PostCommentTable;
use Erlage\Photogram\Data\Tables\Post\PostCommentLikeTable;
use Erlage\Photogram\Data\Models\Post\Comment\Like\PostCommentLikeModel;

final class PostCommentModelHelper
{
    public static function updateCacheLikesCount(PostCommentModel $postCommentModel): void
    {
        $currentCount = (new Query())
            -> from(PostCommentLikeTable::TABLE_NAME)
            -> where(PostCommentLikeTable::LIKED_POST_COMMENT_ID, $postCommentModel -> getId())
            -> count();

        $postCommentModel -> update(array(
            PostCommentTable::CACHE_LIKES_COUNT => $currentCount,
        ));

        $postCommentModel -> save();
    }

    public static function updateCacheCommentsCount(PostCommentModel $postCommentModel): void
    {
        $currentCount = (new Query())
            -> from(PostCommentTable::TABLE_NAME)
            -> where(PostCommentTable::PARENT_POST_ID, $postCommentModel -> getParentPostId())
            -> where(PostCommentTable::REPLY_TO_POST_COMMENT_ID, $postCommentModel -> getId())
            -> count();

        $postCommentModel -> update(array(
            PostCommentTable::CACHE_COMMENTS_COUNT => $currentCount,
        ));

        $postCommentModel -> save();
    }

    public static function deleteDependencies(PostCommentModel $postCommentModel): void
    {
        // delete child models

        /**
        * @var PostCommentLikeModel[]
        */
        $postCommentLikeModels = CommonQueries::beansWithMatchingPredicates(
            PostCommentLikeTable::getTableName(),
            array(
                PostCommentLikeTable::LIKED_POST_COMMENT_ID => $postCommentModel -> getId(),
            )
        );

        foreach ($postCommentLikeModels as $postCommentLikeModel)
        {
            $postCommentLikeModel -> delete();
        }
    }
}
